class Stats extends Mutator config(StatsDB);

//Database vars:
var config string	Pname[20000], TopPname[10];
var config int		Frags[20000], TopFrags[10],
			Deaths[20000], TopDeaths[10],
			Headshots[20000], TopHeadshots[10],
			Games[20000], TopGames[10];

//temp vars:
var string		TempPname[64];
var int			TempFrags[64],
			TempDeaths[64],
			TempHeadShots[64];

//Misc vars:
var bool 	bInit,
		bStatsTransfered,
		bMatchEnded;
var int		Cycle;

function AssignTopInfo(PlayerPawn Other)
{
local Info_PRI PRI;

		PRI = Info_PRI(Other.PlayerReplicationInfo);

		PRI.Name1 = TopPname[0];
		PRI.Name2 = TopPname[1];
		PRI.Name3 = TopPname[2];
		PRI.Name4 = TopPname[3];
		PRI.Name5 = TopPname[4];
		PRI.Name6 = TopPname[5];
		PRI.Name7 = TopPname[6];
		PRI.Name8 = TopPname[7];
		PRI.Name9 = TopPname[8];
		PRI.Name10 = TopPname[9];

		PRI.Frags1 = TopFrags[0];
		PRI.Frags2 = TopFrags[1];
		PRI.Frags3 = TopFrags[2];
		PRI.Frags4 = TopFrags[3];
		PRI.Frags5 = TopFrags[4];
		PRI.Frags6 = TopFrags[5];
		PRI.Frags7 = TopFrags[6];
		PRI.Frags8 = TopFrags[7];
		PRI.Frags9 = TopFrags[8];
		PRI.Frags10 = TopFrags[9];

		PRI.Deaths1 = TopDeaths[0];
		PRI.Deaths2 = TopDeaths[1];
		PRI.Deaths3 = TopDeaths[2];
		PRI.Deaths4 = TopDeaths[3];
		PRI.Deaths5 = TopDeaths[4];
		PRI.Deaths6 = TopDeaths[5];
		PRI.Deaths7 = TopDeaths[6];
		PRI.Deaths8 = TopDeaths[7];
		PRI.Deaths9 = TopDeaths[8];
		PRI.Deaths10 = TopDeaths[9];

		PRI.HS1 = TopHeadshots[0];
		PRI.HS2 = TopHeadshots[1];
		PRI.HS3 = TopHeadshots[2];
		PRI.HS4 = TopHeadshots[3];
		PRI.HS5 = TopHeadshots[4];
		PRI.HS6 = TopHeadshots[5];
		PRI.HS7 = TopHeadshots[6];
		PRI.HS8 = TopHeadshots[7];
		PRI.HS9 = TopHeadshots[8];
		PRI.HS10 = TopHeadshots[9];


		PRI.G1 = TopGames[0];
		PRI.G2 = TopGames[1];
		PRI.G3 = TopGames[2];
		PRI.G4 = TopGames[3];
		PRI.G5 = TopGames[4];
		PRI.G6 = TopGames[5];
		PRI.G7 = TopGames[6];
		PRI.G8 = TopGames[7];
		PRI.G9 = TopGames[8];
		PRI.G10 = TopGames[9];

		Other.Tag = 'tagged';


}

function PostBeginPlay()
{
local int i;

	if (bInit)
		return;
	bInit = True;

	//log("Stats mutator activated");

	settimer(0.001, true);

	//clear temp vars:
	for ( i=0; i<64; i++ )
		{
		TempPname[i] = "";
		TempFrags[i] = 0;
		TempDeaths[i] = 0;
		}
}
function Timer()
{
	DataHandler();
}

function DataHandler()
{
local Info_PRI PRI;
local Pawn P;
local int i;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if (P.IsA('PlayerPawn'))
			{
			PRI = Info_PRI(PlayerPawn(P).PlayerReplicationInfo);

			for ( i=0; i<64; i++ )
				{
				if (TempPname[i] == PRI.PlayerName || TempPname[i] == "")
					{
					TempPname[i] = PRI.PlayerName;
					TempFrags[i] = PRI.Score;
					TempDeaths[i] = PRI.Deaths;
					TempHeadShots[i] = PRI.Headshots;
					if ( Pname[Cycle] == PRI.PlayerName )
						{
						PRI.Games = Games[Cycle];
						if ( !bMatchEnded )
							{
							PRI.TotalHeadShots = Headshots[Cycle] + PRI.Headshots;
							PRI.TotalFrags = Frags[Cycle] + PRI.Score;
							PRI.TotalDeaths = Deaths[Cycle] + PRI.Deaths;
							}
						else
							{
							PRI.TotalHeadShots = Headshots[Cycle];
							PRI.TotalFrags = Frags[Cycle];
							PRI.TotalDeaths = Deaths[Cycle];
							}
						}
					if ( P.Tag != 'tagged' )
						{
						AssignTopInfo(PlayerPawn(P));
						}
					i = 65;
					}
				}	
			}
/* Remove bots from the statistics
		else if (P.IsA('Bot'))
			{
			PRI = Info_PRI(Bot(P).PlayerReplicationInfo);

			for ( i=0; i<64; i++ )
				{
				if (TempPname[i] == PRI.PlayerName || TempPname[i] == "")
					{
					TempPname[i] = PRI.PlayerName;
					TempFrags[i] = PRI.Score;
					TempDeaths[i] = PRI.Deaths;
					TempHeadShots[i] = PRI.Headshots;
					if ( Pname[Cycle] == PRI.PlayerName )
						{
						PRI.Games = Games[Cycle];
						if ( !bMatchEnded )
							{
							PRI.TotalHeadShots = Headshots[Cycle] + PRI.Headshots;
							PRI.TotalFrags = Frags[Cycle] + PRI.Score;
							PRI.TotalDeaths = Deaths[Cycle] + PRI.Deaths;
							}
						else
							{
							PRI.TotalHeadShots = Headshots[Cycle];
							PRI.TotalFrags = Frags[Cycle];
							PRI.TotalDeaths = Deaths[Cycle];
							}
						}
					i = 65;
					}
				}	
			}
*/
		}
	Cycle++;
	if ( Cycle > 20000 || Pname[Cycle] == "" )
		{
		Cycle = 0;
		}
}

function StatsActivated()
{
local Info_PRI PRI;
local Pawn P;
local int i,ii;

	if ( !bStatsTransfered )
		{
		//Collect final data
		DataHandler();

		// transfer to DB
		for ( i=0; i<64; i++ )
			{
			if (TempPname[i] != "")
				{
				for ( ii=0; ii<20000; ii++ )
					{
					if ( Pname[ii] == TempPname[i] || Pname[ii] == "")
						{
						Pname[ii] = TempPname[i];
						Frags[ii] += TempFrags[i];
						Deaths[ii] += TempDeaths[i];
						Headshots[ii] += TempHeadShots[i];
						Games[ii]++;
						ii = 30000;
						}
					}
				}
			}
		bStatsTransfered = True;
		//log("Stats have been transfered to the database succesfully.");
		}
}

function GetTopPlayers()
{
local int i;

	//Get #1
	for ( i=0;i<20000;i++ )
		{
		if ( Frags[i] > TopFrags[0] )
			{
			TopPname[0] = Pname[i];
			TopFrags[0] = Frags[i];
			TopDeaths[0] = Deaths[i];
			TopHeadshots[0] = Headshots[i];
			TopGames[0] = Games[i];
			}
		}
	//Get #2
	for ( i=0;i<20000;i++ )
		{
		if ( Frags[i] > TopFrags[1] && PName[i] != TopPname[0])
			{
			TopPname[1] = Pname[i];
			TopFrags[1] = Frags[i];
			TopDeaths[1] = Deaths[i];
			TopHeadshots[1] = Headshots[i];
			TopGames[1] = Games[i];
			}
		}
	//Get #3
	for ( i=0;i<20000;i++ )
		{
		if ( Frags[i] > TopFrags[2] && PName[i] != TopPname[0] && PName[i] != TopPname[1])
			{
			TopPname[2] = Pname[i];
			TopFrags[2] = Frags[i];
			TopDeaths[2] = Deaths[i];
			TopHeadshots[2] = Headshots[i];
			TopGames[2] = Games[i];
			}
		}
	//Get #4
	for ( i=0;i<20000;i++ )
		{
		if ( Frags[i] > TopFrags[3] && PName[i] != TopPname[0] && PName[i] != TopPname[1] && PName[i] != TopPname[2])
			{
			TopPname[3] = Pname[i];
			TopFrags[3] = Frags[i];
			TopDeaths[3] = Deaths[i];
			TopHeadshots[3] = Headshots[i];
			TopGames[3] = Games[i];
			}
		}
	//Get #5
	for ( i=0;i<20000;i++ )
		{
		if ( Frags[i] > TopFrags[4] && PName[i] != TopPname[0] && PName[i] != TopPname[1] && PName[i] != TopPname[2] && PName[i] != TopPname[3])
			{
			TopPname[4] = Pname[i];
			TopFrags[4] = Frags[i];
			TopDeaths[4] = Deaths[i];
			TopHeadshots[4] = Headshots[i];
			TopGames[4] = Games[i];
			}
		}
	//Get #6
	for ( i=0;i<20000;i++ )
		{
		if ( Frags[i] > TopFrags[5] && PName[i] != TopPname[0] && PName[i] != TopPname[1] && PName[i] != TopPname[2] && PName[i] != TopPname[3] && PName[i] != TopPname[4])
			{
			TopPname[5] = Pname[i];
			TopFrags[5] = Frags[i];
			TopDeaths[5] = Deaths[i];
			TopHeadshots[5] = Headshots[i];
			TopGames[5] = Games[i];
			}
		}
	//Get #7
	for ( i=0;i<20000;i++ )
		{
		if ( Frags[i] > TopFrags[6] && PName[i] != TopPname[0] && PName[i] != TopPname[1] && PName[i] != TopPname[2] && PName[i] != TopPname[3] && PName[i] != TopPname[4] && PName[i] != TopPname[5])
			{
			TopPname[6] = Pname[i];
			TopFrags[6] = Frags[i];
			TopDeaths[6] = Deaths[i];
			TopHeadshots[6] = Headshots[i];
			TopGames[6] = Games[i];
			}
		}
	//Get #8
	for ( i=0;i<20000;i++ )
		{
		if ( Frags[i] > TopFrags[7] && PName[i] != TopPname[0] && PName[i] != TopPname[1] && PName[i] != TopPname[2] && PName[i] != TopPname[3] && PName[i] != TopPname[4] && PName[i] != TopPname[5] && PName[i] != TopPname[6])
			{
			TopPname[7] = Pname[i];
			TopFrags[7] = Frags[i];
			TopDeaths[7] = Deaths[i];
			TopHeadshots[7] = Headshots[i];
			TopGames[7] = Games[i];
			}
		}
	//Get #9
	for ( i=0;i<20000;i++ )
		{
		if ( Frags[i] > TopFrags[8] && PName[i] != TopPname[0] && PName[i] != TopPname[1] && PName[i] != TopPname[2] && PName[i] != TopPname[3] && PName[i] != TopPname[4] && PName[i] != TopPname[5] && PName[i] != TopPname[6] && PName[i] != TopPname[7])
			{
			TopPname[8] = Pname[i];
			TopFrags[8] = Frags[i];
			TopDeaths[8] = Deaths[i];
			TopHeadshots[8] = Headshots[i];
			TopGames[8] = Games[i];
			}
		}
	//Get #10
	for ( i=0;i<20000;i++ )
		{
		if ( Frags[i] > TopFrags[9] && PName[i] != TopPname[0] && PName[i] != TopPname[1] && PName[i] != TopPname[2] && PName[i] != TopPname[3] && PName[i] != TopPname[4] && PName[i] != TopPname[5] && PName[i] != TopPname[6] && PName[i] != TopPname[7] && PName[i] != TopPname[8])
			{
			TopPname[9] = Pname[i];
			TopFrags[9] = Frags[i];
			TopDeaths[9] = Deaths[i];
			TopHeadshots[9] = Headshots[i];
			TopGames[9] = Games[i];
			}
		}

}

function bool HandleEndGame()
{
	StatsActivated();
	GetTopPlayers();
	bMatchEnded = True;
	SaveConfig();
	//log("Initiating transfering of stats to the database.");
}



defaultproperties
{
bMatchEnded=False
}
